/* 
 *  KVPTabBase.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CustomFieldListI;

import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;

public abstract class KVPTabBase {

    private final Tab tab;
    private final String BLANKDATA = "no data to display";
    private final ObservableList<KVPItem> list = FXCollections.observableArrayList();
    private final TableView<KVPItem> table = new TableView<KVPItem>();
    private final BorderPane pane = new BorderPane();
    private final String title;

    public KVPTabBase(String title) {
        this.title = title;
        tab = new Tab();
        createTable();

        tab.setText(title + "s");
        tab.setClosable(false);

        pane.setCenter(table);
        tab.setContent(pane);
        tab.setDisable(true);
    }

    private void createTable() {
        getTable().setEditable(false);
        getTable().setPlaceholder(new Label(BLANKDATA));
        TableColumn<KVPItem, String> name = new TableColumn<KVPItem, String>("Name");
        name.getStyleClass().add("kvpTableNameRows");
        name.setCellValueFactory(
                new Callback<TableColumn.CellDataFeatures<KVPItem, String>, ObservableValue<String>>() {
                    @Override
                    public ObservableValue<String> call(TableColumn.CellDataFeatures<KVPItem, String> p) {
                        return new ReadOnlyObjectWrapper<String>(p.getValue().getName());
                    }
                });
        TableColumn<KVPItem, String> value = new TableColumn<KVPItem, String>("Value");
        value.getStyleClass().add("kvpTableValueRows");
        value.setCellValueFactory(
                new Callback<TableColumn.CellDataFeatures<KVPItem, String>, ObservableValue<String>>() {
                    @Override
                    public ObservableValue<String> call(TableColumn.CellDataFeatures<KVPItem, String> p) {
                        return new ReadOnlyObjectWrapper<String>(p.getValue().getValue());
                    }
                });
        getTable().setItems(getList());
        getTable().getColumns().add(name);
        getTable().getColumns().add(value);
    }

    void update(InteractionDataI data) {}
    void update(CustomFieldListI customFields) {}

    public Tab getTab() {
        return tab;
    }

    public String getTitle() {
        return title;
    }

    public ObservableList<KVPItem> getList() {
        return list;
    }

    public TableView<KVPItem> getTable() {
        return table;
    }

    public BorderPane getPane() {
        return pane;
    }

}
